/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.postag.TagDictionary;

public class POSDictionary
implements TagDictionary {
    private Map dictionary = new HashMap();
    private boolean caseSensitive;

    public POSDictionary(String file) throws IOException {
        this(file, true);
    }

    public POSDictionary(String file, boolean caseSensitive) throws IOException {
        this(new BufferedReader(new FileReader(file)), caseSensitive);
    }

    public POSDictionary(BufferedReader reader, boolean caseSensitive) throws IOException {
        this.caseSensitive = caseSensitive;
        String line = reader.readLine();
        while (line != null) {
            String[] parts = line.split(" ");
            String[] tags = new String[parts.length - 1];
            int tl = parts.length - 1;
            for (int ti = 0; ti < tl; ++ti) {
                tags[ti] = parts[ti + 1];
            }
            this.dictionary.put(parts[0], tags);
            line = reader.readLine();
        }
    }

    public String[] getTags(String word) {
        if (this.caseSensitive) {
            return (String[])this.dictionary.get(word);
        }
        return (String[])this.dictionary.get(word.toLowerCase());
    }

    public static void main(String[] args) throws IOException {
        POSDictionary dict = new POSDictionary(args[0]);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String line = in.readLine();
        while (line != null) {
            System.out.println(Arrays.asList(dict.getTags(line)));
            line = in.readLine();
        }
    }
}

