/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.uima.aae.controller.AnalysisEngineInstancePool;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.analysis_engine.AnalysisEngine;

public class AnalysisEngineInstancePoolWithThreadAffinity
implements AnalysisEngineInstancePool {
    private static final Class CLASS_NAME = AnalysisEngineInstancePoolWithThreadAffinity.class;
    private volatile boolean destroyAEInstanceIfFree = false;
    private Semaphore lock = new Semaphore(1);
    private Map<Long, AnalysisEngine> aeInstanceMap = new HashMap<Long, AnalysisEngine>();

    public int size() {
        return this.aeInstanceMap.size();
    }

    public void checkin(AnalysisEngine anAnalysisEngine) throws Exception {
        try {
            block5: {
                try {
                    this.lock.acquireUninterruptibly();
                    if (this.destroyAEInstanceIfFree) {
                        System.out.println("........... AnalysisEngineInstancePool.checkin() - Thread:" + Thread.currentThread().getId() + " calling destroy() on AE checkin");
                        anAnalysisEngine.destroy();
                        break block5;
                    }
                    this.aeInstanceMap.put(Thread.currentThread().getId(), anAnalysisEngine);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            Object var4_2 = null;
            this.lock.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.lock.release();
            throw throwable;
        }
    }

    public boolean exists() {
        return this.aeInstanceMap.containsKey(Thread.currentThread().getId());
    }

    public AnalysisEngine checkout() throws Exception {
        try {
            this.lock.acquireUninterruptibly();
            if (!this.exists()) {
                throw new AsynchAEException("AE instance not found in AE pool. Most likely due to service quiescing");
            }
            AnalysisEngine analysisEngine = this.aeInstanceMap.remove(Thread.currentThread().getId());
            Object var3_3 = null;
            this.lock.release();
            return analysisEngine;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.lock.release();
                throw throwable;
            }
        }
    }

    public void destroy() throws Exception {
        System.out.println("....... AnalysisEngineInstancePool.destroy() was called");
        this.destroyAEInstanceIfFree = true;
    }
}

