/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.controller.AnalysisEngineControllerAdapter;
import org.apache.uima.aae.controller.ConnectionHandler;
import org.apache.uima.aae.controller.ControllerCallbackListener;
import org.apache.uima.aae.controller.ControllerLifecycle;
import org.apache.uima.aae.controller.LoggerHandler;
import org.apache.uima.aae.controller.StderrHandler;
import org.apache.uima.aae.controller.StdoutHandler;
import org.apache.uima.aae.controller.UimacppServiceManagement;
import org.apache.uima.aae.controller.UimacppShutdownHook;
import org.apache.uima.aae.controller.WaitThread;
import org.apache.uima.aae.jmx.JmxManagement;
import org.apache.uima.internal.util.JmxMBeanAgent;
import org.apache.uima.resource.ManagementObject;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.springframework.beans.factory.DisposableBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UimacppServiceController
extends AnalysisEngineControllerAdapter
implements ControllerLifecycle,
DisposableBean {
    private static final Class CLASS_NAME = UimacppServiceController.class;
    private static final String STARTING_DIRECTORY = "UIMACPP_STARTING_DIRECTORY";
    protected ServerSocket server;
    private int port;
    private Socket loggerConnection;
    private Socket commandConnection;
    protected Process uimacppProcess;
    private LoggerHandler loggerHandler;
    private StdoutHandler stdoutHandler;
    private StderrHandler stderrHandler;
    private ProcessBuilder builder;
    private String startingDirectory;
    private String aeDesc;
    private String queueName;
    private int numInstances;
    private int processCasErrorThreshhold;
    private int processCasErrorWindow;
    private boolean terminateOnCPCError;
    private Logger uimaLogger;
    protected UimacppServiceManagement mbean;
    private JmxManagement jmxMgmt;
    private UimacppShutdownHook shutdownHook;
    private int initialFsHeapSize;
    private ArrayList<ControllerCallbackListener> listeners = new ArrayList();
    private Boolean InitializedState = false;
    private Exception InitializedStatus = null;
    private Boolean isStopped = false;
    private String uimacppHome;

    public UimacppServiceController(String aeDescriptorFileName, String queueName, String brokerURL, int numInstances, int prefetchSize, Map<String, String> envVarMap, int processCasErrorThreshhold, int processCasErrorWindow, boolean terminateOnCPCError, int initialFsHeapSize) throws ResourceInitializationException {
        try {
            this.uimaLogger = UIMAFramework.getLogger(this.getClass());
            this.aeDesc = aeDescriptorFileName;
            this.numInstances = numInstances;
            this.queueName = queueName;
            this.processCasErrorThreshhold = processCasErrorThreshhold;
            this.processCasErrorWindow = processCasErrorWindow;
            this.terminateOnCPCError = terminateOnCPCError;
            this.initialFsHeapSize = initialFsHeapSize;
            this.startingDirectory = envVarMap.get(STARTING_DIRECTORY);
            this.isStopped = false;
            this.server = new ServerSocket(0);
            this.port = this.server.getLocalPort();
            this.server.setSoTimeout(10000);
            ArrayList<String> commandArgs = new ArrayList<String>();
            this.buildCommandArgs(commandArgs, envVarMap, "deployCppService");
            if (brokerURL != null && brokerURL.length() > 0) {
                commandArgs.add("-b");
                commandArgs.add(brokerURL);
            }
            commandArgs.add("-p");
            commandArgs.add(Integer.toString(prefetchSize));
            this.builder = new ProcessBuilder(commandArgs);
            this.setEnvironmentVariables(envVarMap);
            this.uimaLogger.log(Level.INFO, "Starting C++ service: " + commandArgs.toString());
            this.uimaLogger.log(Level.INFO, " env params: " + envVarMap.toString());
            this.startService();
            this.mbean = new UimacppServiceManagement("org.apache.uima:type=ee.jms.services,", this.commandConnection, this.aeDesc, numInstances, brokerURL, queueName);
            JmxMBeanAgent.registerMBean((ManagementObject)this.mbean, null);
            this.notifyInitializationStatus(null);
        }
        catch (IOException e) {
            this.notifyInitializationStatus(e);
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (UIMAException e) {
            this.notifyInitializationStatus((Exception)((Object)e));
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInitializationStatus(Exception e) {
        UimacppServiceController uimacppServiceController = this;
        synchronized (uimacppServiceController) {
            if (!this.InitializedState.booleanValue()) {
                this.InitializedStatus = e;
                this.InitializedState = true;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (e != null) {
                    this.listeners.get(i).notifyOnInitializationFailure(e);
                    continue;
                }
                this.listeners.get(i).notifyOnInitializationSuccess();
            }
        }
    }

    public UimacppServiceController(String aeDescriptorFileName, String queueName, String brokerURL, int numInstances, int prefetchSize, Map<String, String> envVarMap, int processCasErrorThreshhold, int processCasErrorWindow, boolean terminateOnCPCError) throws ResourceInitializationException {
        this(aeDescriptorFileName, queueName, brokerURL, numInstances, prefetchSize, envVarMap, processCasErrorThreshhold, processCasErrorWindow, terminateOnCPCError, 0);
    }

    public UimacppServiceController(Logger uimaLogger, String aeDescriptorFileName, String queueName, String mqHostName, int mqPort, String mqChannel, String mqQueueMgr, int numInstances, Map<String, String> envVarMap, int processCasErrorThreshhold, int processCasErrorWindow, boolean terminateOnCPCError, JmxManagement jmxManagement, int initialFsHeapSize) throws ResourceInitializationException {
        try {
            this.uimaLogger = UIMAFramework.getLogger(this.getClass());
            this.aeDesc = aeDescriptorFileName;
            this.numInstances = numInstances;
            this.queueName = queueName;
            this.processCasErrorThreshhold = processCasErrorThreshhold;
            this.processCasErrorWindow = processCasErrorWindow;
            this.terminateOnCPCError = terminateOnCPCError;
            this.initialFsHeapSize = initialFsHeapSize;
            this.startingDirectory = envVarMap.get(STARTING_DIRECTORY);
            this.jmxMgmt = jmxManagement;
            this.isStopped = false;
            this.server = new ServerSocket(0);
            this.port = this.server.getLocalPort();
            this.server.setSoTimeout(10000);
            ArrayList<String> commandArgs = new ArrayList<String>();
            this.buildCommandArgs(commandArgs, envVarMap, "deployWMQCppService");
            if (mqHostName != null && mqHostName.length() > 0) {
                commandArgs.add("-mqh");
                commandArgs.add(mqHostName);
            }
            commandArgs.add("-mqp");
            commandArgs.add(Integer.toString(mqPort));
            if (mqChannel != null && mqChannel.length() > 0) {
                commandArgs.add("-mqc");
                commandArgs.add(mqChannel);
            }
            if (mqQueueMgr != null && mqQueueMgr.length() > 0) {
                commandArgs.add("-mqm");
                commandArgs.add(mqQueueMgr);
            }
            this.builder = new ProcessBuilder(commandArgs);
            this.setEnvironmentVariables(envVarMap);
            this.uimaLogger.log(Level.INFO, "Starting C++ service: " + commandArgs.toString());
            this.uimaLogger.log(Level.INFO, " env params: " + envVarMap.toString());
            this.startService();
            this.mbean = new UimacppServiceManagement(null, this.commandConnection, this.aeDesc, numInstances, mqHostName + " " + mqPort + "//" + mqQueueMgr, "queue:///" + queueName);
            if (jmxManagement == null) {
                throw new ResourceInitializationException((Throwable)new IOException("JmxManagement object is null."));
            }
            this.mbean = new UimacppServiceManagement(jmxManagement.getJmxDomain(), this.commandConnection, this.aeDesc, numInstances, mqHostName + " " + mqPort + "//" + mqQueueMgr, queueName);
            ObjectName oname = new ObjectName(this.mbean.getUniqueMBeanName());
            jmxManagement.registerMBean(this.mbean, oname);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (UIMAException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (NullPointerException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private void buildCommandArgs(ArrayList<String> commandArgs, Map<String, String> envVarMap, String exeName) throws ResourceInitializationException {
        Pattern mSlashDosDrive;
        Matcher matcher;
        this.uimacppHome = envVarMap.get("UIMACPP_HOME");
        if (this.uimacppHome == null) {
            this.uimacppHome = System.getenv("UIMACPP_HOME");
            if (this.uimacppHome == null) {
                this.uimacppHome = System.getenv("UIMA_HOME") + "/uimacpp";
            }
        }
        if (!new File(this.uimacppHome).exists()) {
            throw new ResourceInitializationException((Throwable)new IOException("Invalid location of UIMACPP_HOME " + this.uimacppHome));
        }
        String cmd = this.uimacppHome + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + exeName;
        commandArgs.add(cmd);
        if (this.aeDesc.regionMatches(true, 0, "file:", 0, 5)) {
            this.aeDesc = this.aeDesc.substring(5);
        }
        if ((matcher = (mSlashDosDrive = Pattern.compile("/[a-zA-Z]:")).matcher(this.aeDesc)).find(0)) {
            this.aeDesc = this.aeDesc.substring(1);
        }
        commandArgs.add(this.aeDesc);
        if (!new File(this.aeDesc).exists()) {
            throw new ResourceInitializationException((Throwable)new IOException("Invalid location of AE descriptor " + this.aeDesc));
        }
        commandArgs.add(this.queueName);
        commandArgs.add("-jport");
        commandArgs.add(Integer.toString(this.port));
        commandArgs.add("-n");
        if (this.numInstances < 1) {
            this.numInstances = 1;
        }
        commandArgs.add(Integer.toString(this.numInstances));
        commandArgs.add("-l");
        if (this.uimaLogger.isLoggable(Level.FINE) || this.uimaLogger.isLoggable(Level.CONFIG) || this.uimaLogger.isLoggable(Level.FINER) || this.uimaLogger.isLoggable(Level.FINEST) || this.uimaLogger.isLoggable(Level.INFO)) {
            commandArgs.add(Integer.toString(0));
        } else if (this.uimaLogger.isLoggable(Level.WARNING)) {
            commandArgs.add(Integer.toString(1));
        } else if (this.uimaLogger.isLoggable(Level.SEVERE)) {
            commandArgs.add(Integer.toString(2));
        } else {
            commandArgs.add(Integer.toString(-1));
        }
        commandArgs.add("-t");
        if (this.uimaLogger.isLoggable(Level.FINEST)) {
            commandArgs.add(Integer.toString(3));
        } else if (this.uimaLogger.isLoggable(Level.FINER)) {
            commandArgs.add(Integer.toString(2));
        } else if (this.uimaLogger.isLoggable(Level.FINE)) {
            commandArgs.add(Integer.toString(1));
        } else if (this.uimaLogger.isLoggable(Level.CONFIG) || this.uimaLogger.isLoggable(Level.INFO)) {
            commandArgs.add(Integer.toString(0));
        } else {
            commandArgs.add(Integer.toString(-1));
        }
        String uimacppDataPath = envVarMap.get("UIMACPP_DATAPATH");
        if (uimacppDataPath != null && uimacppDataPath.length() != 0) {
            commandArgs.add("-d");
            commandArgs.add(uimacppDataPath);
        }
        if (this.processCasErrorThreshhold > 0) {
            commandArgs.add("-e");
            commandArgs.add(Integer.toString(this.processCasErrorThreshhold));
            if (this.processCasErrorWindow > 0) {
                commandArgs.add("-w");
                commandArgs.add(Integer.toString(this.processCasErrorWindow));
            }
        }
        if (this.terminateOnCPCError) {
            commandArgs.add("-a");
            commandArgs.add("true");
        }
        if (this.initialFsHeapSize > 0) {
            commandArgs.add("-fsheapsz");
            commandArgs.add(Integer.toString(this.initialFsHeapSize));
        }
    }

    public UimacppServiceController(Logger uimaLogger, String aeDescriptorFileName, String queueName, String mqHostName, int mqPort, String mqChannel, String mqQueueMgr, int numInstances, Map<String, String> envVarMap, int processCasErrorThreshhold, int processCasErrorWindow, boolean terminateOnCPCError, JmxManagement jmxManagement) throws ResourceInitializationException {
        this(uimaLogger, aeDescriptorFileName, queueName, mqHostName, mqPort, mqChannel, mqQueueMgr, numInstances, envVarMap, processCasErrorThreshhold, processCasErrorWindow, terminateOnCPCError, jmxManagement, 0);
    }

    /*
     * WARNING - void declaration
     */
    private void setEnvironmentVariables(Map<String, String> envVarMap) {
        String uimacppLibDir;
        String pathKey = "PATH";
        Map<String, String> environment = this.builder.environment();
        if (System.getProperty("os.name").startsWith("Windows")) {
            void var5_9;
            for (String string : environment.keySet()) {
                if (!string.equalsIgnoreCase("PATH")) continue;
                pathKey = string;
                break;
            }
            uimacppLibDir = this.uimacppHome + System.getProperty("file.separator") + "bin";
            String string = environment.get(pathKey);
            if (string != null && string.length() > 0) {
                String string2 = uimacppLibDir + System.getProperty("path.separator") + string;
            } else {
                String string3 = uimacppLibDir;
            }
            environment.put(pathKey, (String)var5_9);
        } else {
            void var5_17;
            void var5_13;
            uimacppLibDir = this.uimacppHome + System.getProperty("file.separator") + "lib";
            String string = environment.get("LD_LIBRARY_PATH");
            if (string != null && string.length() > 0) {
                String string4 = uimacppLibDir + System.getProperty("path.separator") + string;
            } else {
                String string5 = uimacppLibDir;
            }
            environment.put("LD_LIBRARY_PATH", (String)var5_13);
            String string6 = environment.get("DYLD_LIBRARY_PATH");
            if (string6 != null && string6.length() > 0) {
                String string7 = uimacppLibDir + System.getProperty("path.separator") + string6;
            } else {
                String string8 = uimacppLibDir;
            }
            environment.put("DYLD_LIBRARY_PATH", (String)var5_17);
        }
        for (Map.Entry entry : envVarMap.entrySet()) {
            String key = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            if (value2 == null || value2.length() <= 0) continue;
            if (key.equalsIgnoreCase("PATH") || key.equals("LD_LIBRARY_PATH") || key.equals("DYLD_LIBRARY_PATH")) {
                String origValue;
                if (key.equalsIgnoreCase("PATH")) {
                    key = pathKey;
                }
                if ((origValue = environment.get(key)) != null) {
                    value2 = value2 + System.getProperty("path.separator") + origValue;
                }
            }
            environment.put(key, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startService() throws UIMAException {
        try {
            ConnectionHandler handler1 = new ConnectionHandler(this);
            Thread t1 = new Thread(handler1);
            t1.start();
            ConnectionHandler handler2 = new ConnectionHandler(this);
            Thread t2 = new Thread(handler2);
            t2.start();
            if (this.startingDirectory != null && this.startingDirectory.length() > 0) {
                File startingDir = new File(this.startingDirectory);
                if (!startingDir.exists()) {
                    throw new ResourceInitializationException((Throwable)new IOException(this.startingDirectory + " Uimacpp Starting Directory not found. + "));
                }
                this.builder.directory(startingDir);
            }
            this.shutdownHook = new UimacppShutdownHook(this, this.commandConnection, this.uimaLogger);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.uimacppProcess = this.builder.start();
            if (this.uimacppProcess == null) {
                throw new UIMAException(new Throwable("Could not fork process."));
            }
            this.stdoutHandler = new StdoutHandler(this.uimacppProcess, this.uimaLogger);
            Thread t3 = new Thread(this.stdoutHandler);
            t3.start();
            this.stderrHandler = new StderrHandler(this.uimacppProcess, this.uimaLogger);
            Thread t4 = new Thread(this.stderrHandler);
            t4.start();
            t1.join();
            t2.join();
            UimacppServiceController uimacppServiceController = this;
            synchronized (uimacppServiceController) {
                if (this.loggerConnection == null || this.loggerHandler == null || this.commandConnection == null) {
                    throw new ResourceInitializationException((Throwable)new IOException("Could not establish socket connection with C++ service."));
                }
            }
            if (this.uimacppProcess != null) {
                System.out.println("Waiting for Uima C++ service to report init status...");
                BufferedReader in = new BufferedReader(new InputStreamReader(this.commandConnection.getInputStream()));
                StringBuffer sb = new StringBuffer();
                int c = in.read();
                while (c >= 0) {
                    sb.append((char)c);
                    c = in.read();
                    if (c != 10) continue;
                }
                if (!sb.toString().equalsIgnoreCase("0")) {
                    System.out.println("UIMA C++ service at " + this.queueName + " failed to initialize.");
                    System.out.println(sb.toString());
                    this.uimacppProcess.destroy();
                    throw new IOException(sb.toString());
                }
            } else {
                throw new ResourceInitializationException((Throwable)new IOException("Could not start the C++ service."));
            }
            System.out.println("Uima C++ service at " + this.queueName + " Ready to process...");
            WaitThread wt = new WaitThread(this.uimacppProcess, this.uimaLogger, this);
            Thread wThread = new Thread(wt);
            wThread.start();
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException, InterruptedException {
        this.mbean.shutdown();
        if (this.jmxMgmt != null) {
            try {
                this.jmxMgmt.destroy();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ControllerCallbackListener listener = this.listeners.get(i);
                if (listener == null) continue;
                listener.notifyOnTermination("Uima C++ service shutdown.");
            }
            this.listeners.clear();
        }
        UimacppServiceController uimacppServiceController = this;
        synchronized (uimacppServiceController) {
            this.loggerConnection.close();
        }
        this.commandConnection.close();
        this.server.close();
        this.isStopped = true;
    }

    public String getStatistics() throws IOException {
        return this.mbean.getStatisticsAsString();
    }

    public void resetStatistics() throws IOException {
        this.mbean.resetStats();
    }

    protected synchronized void handleConnection(Socket inSock) throws IOException {
        if (this.loggerConnection == null) {
            this.loggerConnection = inSock;
            this.loggerHandler = new LoggerHandler(this.loggerConnection, this.uimaLogger);
            new Thread(this.loggerHandler).start();
        } else {
            this.commandConnection = inSock;
        }
    }

    public static void main(String[] args) {
        block4: {
            HashMap<String, String> envVarMap = new HashMap<String, String>();
            try {
                if (System.getProperty("os.name").startsWith("Windows")) {
                    envVarMap.put("UIMACPP_HOME", "c:\\uimacpp2.0\\uimacpp");
                    envVarMap.put("UIMACPP_LOGFILE", "c:\\temp\\uimacppcontroller.log");
                    envVarMap.put("Path", "c:\\cppExamples2.0\\src");
                    UimacppServiceController controller = new UimacppServiceController("c:/cppExamples2.0/descriptors/DaveDetector.xml", "davedetector", "tcp://localhost:61616", 1, 0, envVarMap, 0, 0, false, 2000000);
                } else {
                    envVarMap.put("UIMACPP_HOME", "/opt/IBM/uimacpp");
                    envVarMap.put("UIMACPP_LOGFILE", "/tmp/bhavani.log");
                    UimacppServiceController controller = new UimacppServiceController(UIMAFramework.getLogger(), "/home/bsiyer/cppExamples/descriptors/DaveDetector.xml", "ORANGE.QUEUE", "sith07.watson.ibm.com", 1414, null, null, 1, envVarMap, 0, 0, false, null, 0);
                }
            }
            catch (ResourceInitializationException e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, UimacppServiceController.class.getName(), "main", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    @Override
    public void terminate() {
        block4: {
            try {
                this.shutdown();
            }
            catch (IOException e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "terminate", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "terminate", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    public void destroy() {
        block4: {
            try {
                this.shutdown();
            }
            catch (IOException e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "destroy", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "destroy", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addControllerCallbackListener(ControllerCallbackListener aListener) {
        UimacppServiceController uimacppServiceController = this;
        synchronized (uimacppServiceController) {
            this.listeners.add(aListener);
            if (this.InitializedState.booleanValue()) {
                if (this.InitializedStatus == null) {
                    aListener.notifyOnInitializationSuccess();
                } else {
                    aListener.notifyOnInitializationFailure(this.InitializedStatus);
                }
            }
        }
    }

    @Override
    public void removeControllerCallbackListener(ControllerCallbackListener aListener) {
        this.listeners.remove(aListener);
    }

    @Override
    public void quiesceAndStop() {
        try {
            String msg = this.mbean.quiesceAndStop();
            this.uimaLogger.log(Level.INFO, "Service reports QuiesceAndStop " + msg);
        }
        catch (IOException e) {
            this.uimaLogger.log(Level.SEVERE, e.getMessage());
        }
    }

    @Override
    public boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public void setStopped() {
        this.isStopped = true;
    }

    public ArrayList<ControllerCallbackListener> getCallbackListeners() {
        return this.listeners;
    }

    @Override
    public String getKey() {
        return "";
    }

    @Override
    public void dumpState(StringBuffer buffer, String lbl1) {
    }

    @Override
    public String getPID() {
        return null;
    }
}

