/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.handler;

import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InProcessCache;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.handler.Handler;
import org.apache.uima.aae.jmx.ServicePerformance;
import org.apache.uima.aae.message.MessageContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.util.Level;

public abstract class HandlerBase
implements Handler {
    private static final Class CLASS_NAME = HandlerBase.class;
    private Handler delegateHandler;
    private Handler parentHandler;
    private String handlerName;
    private AnalysisEngineController controller;

    public AnalysisEngineController getController() {
        return this.controller;
    }

    public void setController(AnalysisEngineController controller) {
        this.controller = controller;
    }

    public static ErrorContext populateErrorContext(MessageContext aMessageCtx) {
        ErrorContext errorContext = new ErrorContext();
        if (aMessageCtx != null) {
            try {
                if (aMessageCtx.propertyExists("Command")) {
                    errorContext.add("Command", aMessageCtx.getMessageIntProperty("Command"));
                }
                if (aMessageCtx.propertyExists("MessageType")) {
                    errorContext.add("MessageType", aMessageCtx.getMessageIntProperty("MessageType"));
                }
                if (aMessageCtx.propertyExists("CasReference")) {
                    errorContext.add("CasReference", aMessageCtx.getMessageStringProperty("CasReference"));
                }
                errorContext.add("RawMsg", aMessageCtx.getRawMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return errorContext;
    }

    public void validate(Object anObjectToHandle) throws AsynchAEException {
        if (anObjectToHandle == null) {
            throw new AsynchAEException("Nothing to Handle - Input Object is Null");
        }
        if (!(anObjectToHandle instanceof MessageContext)) {
            throw new AsynchAEException("Invalid Object in Handler. Expected MessageContext Instead Got::" + anObjectToHandle.getClass().getName());
        }
    }

    public boolean isHandlerForMessage(MessageContext aMessageContext, int anExpectedMessageType, int anExpectedCommand) throws AsynchAEException {
        int messageType = aMessageContext.getMessageIntProperty("MessageType");
        int command = aMessageContext.getMessageIntProperty("Command");
        return anExpectedMessageType == messageType && anExpectedCommand == command;
    }

    public void invokeProcess(CAS aCAS, String anInputCasReferenceId, String aNewCasReferenceId, MessageContext aMessageContext, String aNewCasProducedBy) throws AsynchAEException {
        block7: {
            try {
                this.controller.getMonitor().incrementCount("", "ProcessCount");
                if (this.controller instanceof AggregateAnalysisEngineController) {
                    boolean isNewCAS = aMessageContext.propertyExists("CasSequence");
                    if (isNewCAS) {
                        ((AggregateAnalysisEngineController)this.controller).process(aCAS, anInputCasReferenceId, aNewCasReferenceId, aNewCasProducedBy);
                    } else {
                        ((AggregateAnalysisEngineController)this.controller).process(aCAS, anInputCasReferenceId);
                    }
                    break block7;
                }
                if (this.controller instanceof PrimitiveAnalysisEngineController) {
                    ((PrimitiveAnalysisEngineController)this.controller).process(aCAS, anInputCasReferenceId, aMessageContext.getEndpoint());
                    break block7;
                }
                throw new AsynchAEException("Invalid Controller. Expected AggregateController or PrimitiveController. Got:" + this.controller.getClass().getName());
            }
            catch (AsynchAEException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AsynchAEException(e);
            }
        }
    }

    public void delegate(MessageContext aMessageContext) throws AsynchAEException {
        int messageType = aMessageContext.getMessageIntProperty("MessageType");
        if (this.hasDelegateHandler()) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "delegate", "uimaee_messages", "UIMAEE_dispatch_msg_to_handler__FINE", new Object[]{messageType, aMessageContext.getEndpoint().getEndpoint(), this.getDelegate().getName()});
            }
            this.getDelegate().handle(aMessageContext);
        } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "delegate", "uimaee_messages", "UIMAEE_no_handler_for_message__FINE", new Object[]{messageType, aMessageContext.getEndpoint().getEndpoint()});
        }
    }

    public HandlerBase(String aName) {
        this.handlerName = aName;
    }

    public Handler getDelegate() {
        return this.delegateHandler;
    }

    public void setParent(Handler aHandler) {
        this.parentHandler = aHandler;
    }

    public String getName() {
        return this.handlerName;
    }

    public void setDelegate(Handler aHandler) {
        this.delegateHandler = aHandler;
    }

    public boolean hasDelegateHandler() {
        return this.delegateHandler != null;
    }

    public void removeDelegate(String aHandlerName) {
        if (this.handlerName.equals(aHandlerName)) {
            if (this.hasDelegateHandler()) {
                ((HandlerBase)this.delegateHandler).setParent(this.parentHandler);
                this.parentHandler.setDelegate(this.delegateHandler);
            }
        } else {
            this.delegateHandler.removeDelegate(aHandlerName);
        }
    }

    public void resequenceDelegateHandler(String aHandlerName, int aNewPositionInHandlerChain) {
    }

    public void handle(Object anObjectToHandle) throws AsynchAEException {
        this.getController().getControllerLatch().waitUntilInitialized();
    }

    public void handle(Object anObjectToHandle, String expectedOutputType) throws AsynchAEException {
    }

    protected synchronized void aggregateDelegateStats(MessageContext aMessageContext, String aCasReferenceId) throws AsynchAEException {
        String delegateKey = "";
        try {
            long timeWaitingForCAS;
            Endpoint endp;
            long idleTime;
            long timeToDeserializeCAS;
            long timeToSerializeCAS;
            String casProducerKey;
            delegateKey = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(aMessageContext.getEndpoint().getEndpoint());
            InProcessCache.CacheEntry entry = this.getController().getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
            if (entry == null) {
                throw new AsynchAEException("CasReferenceId:" + aCasReferenceId + " Not Found in the Cache.");
            }
            InProcessCache.CacheEntry inputCasEntry = null;
            String inputCasReferenceId = entry.getInputCasReferenceId();
            ServicePerformance casStats = ((AggregateAnalysisEngineController)this.getController()).getCasStatistics(aCasReferenceId);
            if (inputCasReferenceId != null && this.getController().getInProcessCache().entryExists(inputCasReferenceId) && (casProducerKey = entry.getCasProducerKey()) != null && ((AggregateAnalysisEngineController)this.getController()).isDelegateKeyValid(casProducerKey)) {
                inputCasEntry = this.getController().getInProcessCache().getCacheEntryForCAS(inputCasReferenceId);
            }
            ServicePerformance delegateServicePerformance = ((AggregateAnalysisEngineController)this.getController()).getServicePerformance(delegateKey);
            if (aMessageContext.propertyExists("TimeToSerializeCAS") && (timeToSerializeCAS = Long.valueOf(aMessageContext.getMessageLongProperty("TimeToSerializeCAS")).longValue()) > 0L && delegateServicePerformance != null) {
                delegateServicePerformance.incrementCasSerializationTime(timeToSerializeCAS);
            }
            if (aMessageContext.propertyExists("TimeToDeserializeCAS") && (timeToDeserializeCAS = Long.valueOf(aMessageContext.getMessageLongProperty("TimeToDeserializeCAS")).longValue()) > 0L && delegateServicePerformance != null) {
                delegateServicePerformance.incrementCasDeserializationTime(timeToDeserializeCAS);
            }
            if (aMessageContext.propertyExists("IdleTime") && (idleTime = Long.valueOf(aMessageContext.getMessageLongProperty("IdleTime")).longValue()) > 0L && delegateServicePerformance != null && (endp = aMessageContext.getEndpoint()) != null && endp.isRemote()) {
                delegateServicePerformance.incrementIdleTime(idleTime);
            }
            if (aMessageContext.propertyExists("TimeWaitingForCAS") && (timeWaitingForCAS = Long.valueOf(aMessageContext.getMessageLongProperty("TimeWaitingForCAS")).longValue()) > 0L && aMessageContext.getEndpoint().isRemote()) {
                entry.incrementTimeWaitingForCAS(timeWaitingForCAS);
                delegateServicePerformance.incrementCasPoolWaitTime(timeWaitingForCAS - delegateServicePerformance.getRawCasPoolWaitTime());
                if (inputCasEntry != null) {
                    inputCasEntry.incrementTimeWaitingForCAS(timeWaitingForCAS);
                }
            }
            if (aMessageContext.propertyExists("TimeInProcessCAS")) {
                ServicePerformance inputCasStats;
                long timeInProcessCAS = aMessageContext.getMessageLongProperty("TimeInProcessCAS");
                endp = aMessageContext.getEndpoint();
                if (endp != null && endp.isRemote()) {
                    if (delegateServicePerformance != null) {
                        long dt = timeInProcessCAS - delegateServicePerformance.getRawAnalysisTime();
                        delegateServicePerformance.incrementAnalysisTime(dt);
                        this.getController().getServicePerformance().incrementAnalysisTime(dt);
                    }
                } else {
                    this.getController().getServicePerformance().incrementAnalysisTime(timeInProcessCAS);
                }
                casStats.incrementAnalysisTime(timeInProcessCAS);
                if (inputCasReferenceId != null && (inputCasStats = ((AggregateAnalysisEngineController)this.getController()).getCasStatistics(inputCasReferenceId)) != null) {
                    inputCasStats.incrementAnalysisTime(timeInProcessCAS);
                }
            }
        }
        catch (AsynchAEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    protected void computeStats(MessageContext aMessageContext, String aCasReferenceId) throws AsynchAEException {
        if (aMessageContext.propertyExists("TimeInService")) {
            long departureTime = this.getController().getTime(aCasReferenceId, aMessageContext.getEndpoint().getEndpoint());
            long currentTime = System.nanoTime();
            long roundTrip = currentTime - departureTime;
            long timeInService = aMessageContext.getMessageLongProperty("TimeInService");
            long totalTimeInComms = currentTime - (departureTime - timeInService);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "computeStats", "uimaee_messages", "UIMAEE_show_roundtrip_time__FINE", new Object[]{aCasReferenceId, aMessageContext.getEndpoint(), (double)roundTrip / 1000000.0});
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "computeStats", "uimaee_messages", "UIMAEE_show_time_spent_in_delegate__FINE", new Object[]{aCasReferenceId, (double)timeInService / 1000000.0, aMessageContext.getEndpoint()});
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "computeStats", "uimaee_messages", "UIMAEE_show_time_spent_in_comms__FINE", new Object[]{aCasReferenceId, (double)totalTimeInComms / 1000000.0, aMessageContext.getEndpoint()});
            }
        }
        if (this.getController() instanceof AggregateAnalysisEngineController) {
            this.aggregateDelegateStats(aMessageContext, aCasReferenceId);
        }
    }
}

