/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resourceSpecifier.factory.impl;

import org.apache.uima.resourceSpecifier.CasMultiplierType;
import org.apache.uima.resourceSpecifier.factory.CasMultiplier;
import org.apache.uima.resourceSpecifier.factory.ServiceContext;
import org.springframework.util.Assert;

public class CasMultiplierImpl
implements CasMultiplier {
    private CasMultiplierType cmt;

    protected CasMultiplierImpl(CasMultiplierType cmt) {
        this(cmt, 1, 2000000, false);
    }

    protected CasMultiplierImpl(CasMultiplierType cmt, int casPoolSize, int initialHeapSize, boolean processParentLast) {
        this.cmt = cmt;
        this.setCasPoolSize(casPoolSize);
        this.setInitialFsHeapSize(initialHeapSize);
        this.setProcessParentLast(processParentLast);
    }

    protected CasMultiplierImpl(CasMultiplierType cmt, ServiceContext context) {
        this.cmt = cmt;
        this.setCasPoolSize(context.getCasPoolSize());
        this.setInitialFsHeapSize(context.getInitialHeapSize());
        this.setProcessParentLast(context.processParentLast());
    }

    public int getCasPoolSize() {
        Assert.notNull((Object)this.cmt);
        return this.cmt.getPoolSize();
    }

    public void setCasPoolSize(int casPoolSize) {
        Assert.notNull((Object)this.cmt);
        this.cmt.setPoolSize(casPoolSize);
    }

    public void setInitialFsHeapSize(long initialFsHeapSize) {
        Assert.notNull((Object)this.cmt);
        this.cmt.setInitialFsHeapSize(String.valueOf(initialFsHeapSize));
    }

    public long getInitialFsHeapSize() {
        Assert.notNull((Object)this.cmt);
        long heapSize = 0L;
        try {
            heapSize = Long.parseLong(this.cmt.getInitialFsHeapSize());
        }
        catch (NumberFormatException nfe) {
            heapSize = -1L;
        }
        Assert.isTrue((heapSize > -1L ? 1 : 0) != 0);
        return heapSize;
    }

    public boolean getProcessParentLast() {
        Assert.notNull((Object)this.cmt);
        return Boolean.parseBoolean(this.cmt.getProcessParentLast());
    }

    public void setProcessParentLast(boolean processParentLast) {
        Assert.notNull((Object)this.cmt);
        this.cmt.setProcessParentLast(Boolean.toString(processParentLast));
    }
}

