/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resourceSpecifier.factory.impl;

import org.apache.uima.resourceSpecifier.TopLevelAnalysisEngineType;
import org.apache.uima.resourceSpecifier.factory.AsyncPrimitiveErrorConfiguration;
import org.apache.uima.resourceSpecifier.factory.CasMultiplier;
import org.apache.uima.resourceSpecifier.factory.DelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.Delegates;
import org.apache.uima.resourceSpecifier.factory.Scaleout;
import org.apache.uima.resourceSpecifier.factory.ServiceContext;
import org.apache.uima.resourceSpecifier.factory.TopLevelAnalysisEngine;
import org.apache.uima.resourceSpecifier.factory.impl.AggregateDelegateEngineImpl;
import org.apache.uima.resourceSpecifier.factory.impl.AsyncPrimitiveErrorConfigurationImpl;
import org.apache.uima.resourceSpecifier.factory.impl.CasMultiplierImpl;
import org.apache.uima.resourceSpecifier.factory.impl.DelegatesImpl;
import org.apache.uima.resourceSpecifier.factory.impl.ScaleoutImpl;
import org.springframework.util.Assert;

public class TopLevelAnalysisEngineImpl
implements TopLevelAnalysisEngine {
    private TopLevelAnalysisEngineType tlea;
    private Scaleout inputQueueScaleout = null;
    private Scaleout replyQueueScaleout = null;
    private Delegates delegates = null;
    private AsyncPrimitiveErrorConfiguration ec = null;
    private CasMultiplier cm = null;

    protected TopLevelAnalysisEngineImpl(TopLevelAnalysisEngineType tlea, ServiceContext context, DelegateConfiguration ... delegateConfigurations) {
        this.tlea = tlea;
        if (context.isCasMultiplier()) {
            this.cm = new CasMultiplierImpl(tlea.addNewCasMultiplier(), context);
        }
        if (delegateConfigurations != null && delegateConfigurations.length > 0) {
            tlea.setAsync("true");
            AggregateDelegateEngineImpl aggregateDelegateEngine = new AggregateDelegateEngineImpl(tlea, "", context, delegateConfigurations);
            this.delegates = new DelegatesImpl(tlea.addNewDelegates(), aggregateDelegateEngine, context, delegateConfigurations);
        } else {
            tlea.setAsync(String.valueOf(context.isAsync()));
            this.ec = new AsyncPrimitiveErrorConfigurationImpl(tlea.addNewAsyncPrimitiveErrorConfiguration(), context, true);
            this.inputQueueScaleout = new ScaleoutImpl(tlea.addNewScaleout(), context);
        }
    }

    public Scaleout getInputQueueScaleout() {
        Assert.notNull((Object)this.inputQueueScaleout);
        return this.inputQueueScaleout;
    }

    public void setInputQueueScaleout(Scaleout scaleup) {
        Assert.notNull((Object)this.tlea);
        if (this.inputQueueScaleout == null) {
            this.getInputQueueScaleout().setNumberOfInstances(scaleup.getNumberOfInstances());
        }
    }

    public Scaleout getReplyQueueScaleout() {
        Assert.notNull((Object)this.tlea);
        if (this.replyQueueScaleout == null) {
            // empty if block
        }
        return this.replyQueueScaleout;
    }

    public void setReplyQueueScaleout(Scaleout replyQueueScaleout) {
        Assert.notNull((Object)this.tlea);
        this.tlea.setInternalReplyQueueScaleout(String.valueOf(replyQueueScaleout));
    }

    public Delegates getDelegates() {
        Assert.notNull((Object)this.delegates);
        return this.delegates;
    }

    public void setDelegates(Delegates delegates) {
        Assert.notNull((Object)this.tlea);
    }

    public CasMultiplier getCasMultiplier() {
        Assert.notNull((Object)this.tlea);
        return null;
    }

    public AsyncPrimitiveErrorConfiguration getPrimitiveErrorConfiguration() {
        Assert.notNull((Object)this.ec);
        return this.ec;
    }

    public void setPrimitiveErrorConfiguration(AsyncPrimitiveErrorConfiguration ec) {
        Assert.notNull((Object)this.tlea);
    }

    public String getKey() {
        Assert.notNull((Object)this.tlea);
        return null;
    }

    public void setKey(String key) {
        Assert.notNull((Object)this.tlea);
    }

    public boolean isAsync() {
        Assert.notNull((Object)this.tlea);
        return false;
    }

    public void setIsAsync() {
        Assert.notNull((Object)this.tlea);
    }

    public void setReplyQueueScaleout() {
    }
}

